'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: $Id: itcl_class.n,v 1.1 2003/02/05 10:53:53 mdejong Exp $
'\"
.so man.macros
.TH itcl_class n 3.0 itcl "[incr\ Tcl]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
itcl_class \- create a class of objects (obsolete)
.SH SYNOPSIS
\fBitcl_class \fIclassName\fR \fB{
.br
    \fBinherit \fIbaseClass\fR ?\fIbaseClass\fR...?
.br
    \fBconstructor \fIargs\fR ?\fIinit\fR? \fIbody\fR
.br
    \fBdestructor \fIbody\fR
.br
    \fBmethod \fIname args body\fR
.br
    \fBproc \fIname args body\fR
.br
    \fBpublic \fIvarName\fR ?\fIinit\fR? ?\fIconfig\fR?
.br
    \fBprotected \fIvarName\fR ?\fIinit\fR?
.br
    \fBcommon \fIvarName\fR ?\fIinit\fR?
.br
\fB}\fR
.sp
\fIclassName objName\fR ?\fIargs...\fR?
.br
\fIclassName\fR \fB#auto\fR ?\fIargs...\fR?
.br
\fIclassName\fR \fB::\fR \fIproc\fR ?\fIargs...\fR?
.sp
\fIobjName method\fR ?\fIargs...\fR?
.sp
\fICommands available within class methods/procs:\fR
.br
\fBglobal \fIvarName\fR ?\fIvarName...\fR?
.br
\fBprevious \fIcommand\fR ?\fIargs...\fR?
.br
\fBvirtual \fIcommand\fR ?\fIargs...\fR?
.BE

.SH DESCRIPTION
.PP
This command is considered obsolete, but is retained for
backward-compatibility with earlier versions of \fB[incr\ Tcl]\fR.
It has been replaced by the \fBclass\fR command, which should
be used for any new development.

.TP
\fBitcl_class \fIclassName definition\fR
Provides the definition for a class named \fIclassName\fR.  If
\fIclassName\fR is already defined, then this command returns
an error.  If the class definition is successfully parsed,
\fIclassName\fR becomes a command in the current namespace
context, handling the
creation of objects and providing access to class scope.
The class \fIdefinition\fR
is evaluated as a series of Tcl statements that define
elements within the class.  In addition to the usual
commands, the following class definition commands are recognized:
.RS
.TP
\fBinherit \fIbaseClass\fR ?\fIbaseClass\fR...?
Declares one or more base classes, causing the current class to
inherit their characteristics.  Classes must have been defined by
a previous \fBitcl_class\fR command, or must be available to the
auto-loading facility (see "AUTO-LOADING" below).  A single class
definition can contain no more than one \fBinherit\fR command.
.RS
.LP
When the same member name appears in two or more base classes,
the base class that appears first in the \fBinherit\fR list takes
precedence.  For example, if classes "Foo" and "Bar" both contain
the member "x", then the "\fBinherit\fR" statement:
.CS
inherit Foo Bar
.CE
allows "Foo::x" to be accessed simply as "x" but forces "Bar::x" (and
all other inherited members named "x") to be referenced with their
explicit "\fIclass\fR::\fImember\fR" name.
.RE
.TP
\fBconstructor \fIargs\fR ?\fIinit\fR? \fIbody\fR
Declares the argument list and body used for the constructor, which
is automatically invoked whenever an object is created.  Before
.VS
the \fIbody\fR is executed, the optional \fIinit\fR statement is
used to invoke any base class constructors that require arguments.
Variables in the \fIargs\fR specification can be accessed in the
\fIinit\fR code fragment, and passed to base class constructors.
After evaluating the \fIinit\fR statement, any base class
constructors that have not been executed are invoked without
arguments.  This ensures that all base classes are fully
constructed before the constructor \fIbody\fR is executed.
.VE
If construction is successful, the constructor always returns
the object name\-regardless of how the \fIbody\fR is defined\-and
the object name becomes a command in the current namespace context.
If construction fails, an error message is returned.
.TP
\fBdestructor \fIbody\fR
Declares the body used for the destructor, which is automatically invoked
whenever an object is deleted.  If the destructor is successful, the object
data is destroyed and the object name is removed as a command from the
interpreter.  If destruction fails, an error message is returned
and the object remains.
.RS
.LP
.VS
When an object is destroyed, all destructors in a class hierarchy
are invoked in order from most- to least-specific.  This is the
order that the classes are reported by the "\fBinfo heritage\fR"
command, and it is exactly the opposite of the default constructor
order.
.VE
.RE
.TP
\fBmethod \fIname args body\fR
Declares a method called \fIname\fR with an argument list \fIargs\fR
and a \fIbody\fR of Tcl statements.  A method is just like the usual
Tcl "proc" except that it has transparent access to
.VS
object-specific variables, as well as
.VE
common variables.  Within the class scope, a method can be invoked
like any other command\-simply by using its name.  Outside of the
class scope, the method name must be prefaced by an object
name.  Methods in a base class that are redefined in the current class
or hidden by another base class can be explicitly scoped using the
"\fIclass\fR::\fImethod\fR" syntax.
.TP
\fBproc \fIname args body\fR
Declares a proc called \fIname\fR with an argument list \fIargs\fR
and a \fIbody\fR of Tcl statements.  A proc is similar to a method,
except that it can be invoked without referring to a specific object,
and therefore has access only to common variables\-not
.VS
to object-specific variables declared with the \fBpublic\fR
and \fBprotected\fR commands.
.VE
Within the class scope, a proc can be invoked
like any other command\-simply by using its name.  In any other
namespace context, the proc is invoked using a qualified name
like "\fIclassName\fB::\fIproc\fR".
Procs in a base class that are redefined in the current
class, or hidden by another base class, can also be accessed
via their qualified name.
.TP
\fBpublic \fIvarName\fR ?\fIinit\fR? ?\fIconfig\fR?
Declares a public variable named \fIvarName\fR.  Public variables are
visible in methods within the scope of their class and any derived class.
In addition, they can be modified outside of the class scope using the special
"config" formal argument (see "ARGUMENT LISTS" above).  If the optional
\fIinit\fR is specified, it is used as the initial value of the variable
when a new object is created.  If the optional \fIconfig\fR command
is specified,
it is invoked whenever a public variable is modified via the "config"
formal argument; if the \fIconfig\fR command returns an error, the
public variable is reset to its value before configuration, and the
method handling the configuration returns an error.
.TP
\fBprotected \fIvarName\fR ?\fIinit\fR?
Declares a protected variable named \fIvarName\fR.  Protected variables
are visible in methods within the scope of their class and any derived class,
but cannot
be modified outside of the class scope.  If the optional \fIinit\fR
is specified, it is used as the initial value of the variable when a new
object is created.  Initialization forces the variable to be a simple
scalar value; uninitialized variables, on the other hand, can be used
as arrays.  All objects have a built-in protected variable named
"this" which is initialized to the instance name for the object.
.TP
\fBcommon \fIvarName\fR ?\fIinit\fR?
Declares a common variable named \fIvarName\fR.  Common variables are
shared among all objects in a class.  They are visible in methods and
procs in the scope of their class and any derived class, but cannot be
modified outside of the class scope.
If the optional \fIinit\fR is specified, it is used as the
initial value of the variable.  Initialization forces the variable to be
a simple scalar value; uninitialized variables, on the other hand, can
be used as arrays.
.RS
.LP
Once a common variable has been declared, it can be configured using
ordinary Tcl code within the class definition.  This facility is
particularly useful when the initialization of the variable is
non-trivial\-when the variable contains an array of values, for example:
.CS
itcl_class Foo {
     .
     .
    common boolean
    set boolean(true) 1
    set boolean(false) 0
}
.CE
.RE
.RE

.SH CLASS USAGE
.PP
When a class definition has been loaded (or made available to the
auto-loader), the class name can be used as a command.
.TP
\fIclassName objName\fR ?\fIargs...\fR?
Creates a new object in class \fIclassName\fR with the name \fIobjName\fR.
Remaining arguments are passed to the constructor.  If construction is
successful, the object name is returned and this name becomes a command
in the current namespace context.  Otherwise, an error is returned.
.TP
\fIclassName\fR #auto ?\fIargs...\fR?
Creates a new object in class \fIclassName\fR with an automatically
generated name.  Names are of the form \fIclassName<number>\fR,
.VS
where the \fIclassName\fR part is modified to start with a lowercase
letter.  In class "Toaster", for example, the "\fB#auto\fR" specification
would produce names toaster0, toaster1, etc.  Remaining arguments are
.VE
passed to the constructor.  If construction is successful, the object
name is returned and this name becomes a command in the current
namespace context.  Otherwise, an error is returned.
.TP
\fIclassName\fR  ::  \fIproc\fR ?\fIargs...\fR?
Used outside of the class scope to invoke a class proc named \fIproc\fR.
Class procs are like ordinary Tcl procs, except that they are executed
in the scope of the class and therefore have transparent
access to common data members.
.RS
.LP
.VS
Notice that, unlike any other scope qualifier in \fB[incr\ Tcl]\fR, the "::"
shown above is surrounded by spaces.  This is unnecessary with the
new namespace facility, and is considered obsolete.  The capability
is still supported, however, to provide backward-compatibility with
earlier versions.
.VE
.RE

.SH OBJECT USAGE
.TP
\fIobjName method\fR ?\fIargs...\fR?
Invokes a method named \fImethod\fR to operate on the specified object.
Remaining arguments are passed to the method.  The method name can
be "constructor", "destructor", any method name appearing in the
class definition, or any of the following built-in methods.
.SH BUILT-IN METHODS
.TP
\fIobjName\fR \fBisa \fIclassName\fR
Returns non-zero if the given \fIclassName\fR can be found in the
object's heritage, and zero otherwise.
.TP
\fIobjName\fR \fBdelete\fR
Invokes the destructor associated with an object.
If the destructor is successful, data associated with the object is
deleted and \fIobjName\fR is removed as a command from the
interpreter.  Returns the empty string, regardless of the destructor
body.
.RS
.LP
.VS
The built-in \fBdelete\fR method has been replaced by the
"\fBdelete object\fR" command in the global namespace, and
is considered obsolete.  The capability is still supported,
however, to provide backward-compatibility with earlier versions.
.VE
.RE
.TP
\fIobjName\fR \fBinfo \fIoption\fR ?\fIargs...\fR?
Returns information related to the class definition or to
a particular object named \fIobjName\fR.
The \fIoption\fR parameter includes the following things, as well as
the options recognized by the usual Tcl "info" command:
.RS
.TP
\fIobjName\fR \fBinfo class\fR
.VS
Returns the name of the most-specific class for object \fIobjName\fR.
.VE
.TP
\fIobjName\fR \fBinfo inherit\fR
Returns the list of base classes as they were defined in the
"\fBinherit\fR" command, or an empty string if this class
has no base classes.
.TP
\fIobjName\fR \fBinfo heritage\fR
Returns the current class name and the entire list of base classes in
the order that they are traversed for member lookup and object
destruction.
.TP
\fIobjName\fR \fBinfo method\fR ?\fImethodName\fR? ?\fB-args\fR? ?\fB-body\fR?
With no arguments, this command returns a list of all class methods.
If \fImethodName\fR is specified, it returns information for a specific method.
If neither of the optional \fB-args\fR or \fB-body\fR flags is specified,
a complete method definition is returned as a list of three elements
including the method name, argument list and body.  Otherwise, the
requested information is returned without the method name.
If the \fImethodName\fR is not recognized, an empty string is returned.
.TP
\fIobjName\fR \fBinfo proc\fR ?\fIprocName\fR? ?\fB-args\fR? ?\fB-body\fR?
With no arguments, this command returns a list of all class procs.
If \fIprocName\fR is specified, it returns information for a specific proc.
If neither of the optional \fB-args\fR or \fB-body\fR flags is specified,
a complete proc definition is returned as a list of three elements
including the proc name, argument list and body.  Otherwise, the
requested information is returned without the proc name.
If the \fIprocName\fR is not recognized, an empty string is returned.
.TP
\fIobjName\fR \fBinfo public\fR ?\fIvarName\fR? ?\fB-init\fR? ?\fB-value\fR? ?\fB-config\fR?
With no arguments, this command returns a list of all public variables.
If \fIvarName\fR is specified, it returns information for a specific public
variable.
If none of the optional \fB-init\fR, \fB-value\fR or \fB-config\fR flags
are specified, all available information is returned as a list of four
elements including the variable name, initial value, current value,
and configuration commands.  Otherwise, the requested information is
returned without the variable name.
If the \fIvarName\fR is not recognized, an empty string is returned.
.TP
\fIobjName\fR \fBinfo protected\fR ?\fIvarName\fR? ?\fB-init\fR? ?\fB-value\fR?
With no arguments, this command returns a list of all protected variables.
If \fIvarName\fR is specified, it returns information for a specific protected
variable.
If neither of the optional \fB-init\fR or \fB-value\fR flags is specified,
all available information is returned as a list of three elements
including the variable name, initial value and current value.
Otherwise, the requested information is returned without the variable name.
If the \fIvarName\fR is not recognized, an empty string is returned.
.TP
\fIobjName\fR \fBinfo common\fR ?\fIvarName\fR? ?\fB-init\fR? ?\fB-value\fR?
With no arguments, this command returns a list of all common variables.
If \fIvarName\fR is specified, it returns information for a specific common
variable.
If neither of the optional \fB-init\fR or \fB-value\fR flags is specified,
all available information is returned as a list of three elements
including the variable name, initial value and current value.
Otherwise, the requested information is returned without the variable name.
If the \fIvarName\fR is not recognized, an empty string is returned.
.RE
.SH OTHER BUILT-IN COMMANDS
The following commands are also available within the scope of each class.
They cannot be accessed from outside of the class as proper methods or
procs; rather, they are useful inside the class when implementing its
functionality.
.TP
\fBglobal \fIvarName\fR ?\fIvarName...\fR?
Creates a link to one or more global variables in the current
namespace context.  Global variables can also be accessed in
other namespaces by including namespace qualifiers in \fIvarName\fR.
This is useful when communicating with Tk widgets that rely on global
variables.
.TP
\fBprevious \fIcommand\fR ?\fIargs...\fR?
Invokes \fIcommand\fR in the scope of the most immediate base class
.VS
(i.e., the "previous" class) for the object.  For classes using single
.VE
inheritance, this facility can be used to avoid hard-wired base class
references of the form "\fIclass\fR::\fIcommand\fR", making code easier
to maintain.  For classes using multiple inheritance, the utility of
this function is dubious.
If the class at the relevant scope has no base class, an error is returned.
.TP
\fBvirtual \fIcommand\fR ?\fIargs...\fR?
.VS
Invokes \fIcommand\fR in the scope of the most-specific class for the
object.  The methods within a class are automatically virtual; whenever
an unqualified method name is used, it always refers to the most-specific
implementation for that method.  This function provides a way of
evaluating code fragments in a base class that have access to the
most-specific object information.  It is useful, for example, for
creating base classes that can capture and save an object's state.
It inverts the usual notions of object-oriented programming, however,
and should therefore be used sparingly.
.VE

.SH AUTO-LOADING
.PP
Class definitions need not be loaded explicitly; they can be loaded as
needed by the usual Tcl auto-loading facility.  Each directory containing
class definition files should have an accompanying "tclIndex" file.
Each line in this file identifies a Tcl procedure or \fB[incr\ Tcl]\fR
class definition and the file where the definition can be found.
.PP
For example, suppose a directory contains the definitions for classes
"Toaster" and "SmartToaster".  Then the "tclIndex" file for this
directory would look like:
.CS
# Tcl autoload index file, version 2.0 for [incr Tcl]
# This file is generated by the "auto_mkindex" command
# and sourced to set up indexing information for one or
# more commands.  Typically each line is a command that
# sets an element in the auto_index array, where the
# element name is the name of a command and the value is
# a script that loads the command.

set auto_index(::Toaster) "source $dir/Toaster.itcl"
set auto_index(::SmartToaster) "source $dir/SmartToaster.itcl"
.PP
The \fBauto_mkindex\fR command is used to automatically
generate "tclIndex" files.
.CE
The auto-loader must be made aware of this directory by appending
the directory name to the "auto_path" variable.  When this is in
place, classes will be auto-loaded as needed when used in an
application.

.SH KEYWORDS
class, object, object-oriented
