'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: $Id: usual.n,v 1.1 2003/02/05 10:53:58 mdejong Exp $
'\"
.so man.macros
.TH usual n 3.0 itk "[incr\ Tk]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
usual \- access default option-handling commands
.br
	for a mega-widget component
.SH SYNOPSIS
\fBusual ?\fItag\fR? ?\fIcommands\fR?
.BE

.SH DESCRIPTION
.PP
The \fBusual\fR command is used outside of an \fB[incr\ Tcl]\fR
class definition to define the usual set of option-handling
commands for a component widget.  Option-handling commands
are used when a component is registered with the \fBArchetype\fR
base class via the "\fBitk_component add\fR" method.  They
specify how the component's configuration options should be
integrated into the composite option list for the mega-widget.
Options can be kept, renamed, or ignored, as described in the
\fBArchetype\fR man page.
.PP
It is tedious to include the same declarations again and again
whenever components are added.  The \fBusual\fR command allows
a standard code fragment to be registered for each widget class,
which is used by default to handle the options.  All of the
standard Tk widgets have \fBusual\fR declarations defined in
the \fB[incr\ Tk]\fR library.  Similar \fBusual\fR declarations
should be created whenever a new mega-widget class is conceived.
Only the most-generic options should be included in the \fBusual\fR
declaration.
.PP
The \fItag\fR name is usually the name of a widget class,
which starts with a capital letter; however, any string registered
here can be used later with the \fBusual\fR command described
on the \fBArchetype\fR man page.
.PP
If the \fIcommands\fR argument is specified, it is associated
with the \fItag\fR string, and can be accessed later via
\fBitk_component add\fR.
.PP
If only the \fItag\fR argument is specified, this command looks for
an existing \fItag\fR name and returns the commands associated
with it.  If there are no commands associated with \fItag\fR,
this command returns the null string.
.PP
If no arguments are specified, this command returns a list of
all \fItag\fR names previously registered.

.SH EXAMPLE
Following is the \fBusual\fR declaration for the standard
Tk button widget:
.CS
usual Button {
    keep -background -cursor -foreground -font
    keep -activebackground -activeforeground -disabledforeground
    keep -highlightcolor -highlightthickness
    rename -highlightbackground -background background Background
}
.CE
Only the options that would be common to all buttons in a
single mega-widget are kept or renamed.  Options like "-text"
that would be unique to a particular button are ignored.

.SH KEYWORDS
itk, Archetype, component, mega-widget
