/*

html.l

Copyright (C) 2001, Khamis Abuelkomboz.

You should have received a copy of the GNU General Public License along
with Source-Navigator; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.

*/

%{

#include <ctype.h>
#include <stdio.h>
#include "snptools.h"
//#include "lexinput.h"

#undef yywrap
#define YY_SKIP_YYWRAP

#undef YY_INPUT
#define YY_INPUT(buf,r,ms) (r = sn_encoded_input(buf, ms))

#define isSPACE(c) (c==' '||c=='\t')
#define noSPACE(c) (!isSPACE(c))

static char *p;				/* general purpose pointer */
static char group[] = "html";

static struct {
  char cls[512];
  char name[512];
  long line;
  long column;
  int length;
  unsigned char flag;
} last_label = { "class", "dummy", 0, 0, 0, 0 };

static struct {
    char name[64];
    int bracket;
    int line1, line2, pos1, pos2;
} vbPos, clsPos, stylePos[16];
static int brackets = 0, haveFunc = 0, haveClass = 0;
static int funcBracket = 0, classBracket = 0;

enum {
    LNG_VBSCRIPT=0,
    LNG_JSCRIPT,
    LNG_PHP,
    LNG_CSS
};
static current_language = LNG_VBSCRIPT;

static int drop_until(char* term);

static char stylename[64] = {'u', 'n', 'k', 'n', 'o', 'w', 'n', 0};
static int iStyle = 0;
static int stylebracket = 0;

int
yywrap()
{
  return(1);
}

%}

%x COMMENT

alphas		[a-zA-Z]
digits		[0-9]
alphanums	({alphas}|{digits})
word		([a-zA-Z0-9_]+
identifier      ([A-Za-z_][A-Za-z0-9_]*)
specials	[_"."]

ws		[ \t]
ospace		[ \t]*
space		[ \t]+
string          \".*\"
filename	{string}
symbol-name	[a-zA-Z_"."][a-zA-Z0-9_"."]*
style-name	[a-zA-Z0-9_.#:-]+

%x VBSCRIPT
%x JSCRIPT
%x PHP
%x STYLE

%%

\<\%{ospace}\@{ospace}language{ospace}={ospace}(\"|{ospace})vbscript(\"|{ospace}).*\%\> {
    sn_advance_column(yyleng);
    current_language = LNG_VBSCRIPT;
}

\<\%{ospace}\@{ospace}language{ospace}={ospace}(\"|{ospace})(jscript|javascript)(\"|{ospace}).*\%\> {
    sn_advance_column(yyleng);
    current_language = LNG_JSCRIPT;
}

\<\% {
    sn_advance_column(yyleng);
    if (current_language == LNG_VBSCRIPT)
    {
	BEGIN(VBSCRIPT);
    }
    else
    {
	BEGIN(JSCRIPT);
    }
}

\<script{space}language=[^<]*vbscript[^<]*\> {
    sn_advance_column(yyleng);
    BEGIN(VBSCRIPT);
}

<VBSCRIPT>^{ospace}(Sub|Function){space}{identifier} {
	//functions
	char *p;
	int pos;
	p = yytext + yyleng;
	while(noSPACE(*(p-1))) p--;
	pos = sn_column() + (p - yytext);
	
	//Store position
	strcpy(vbPos.name, p);
	vbPos.line1 = sn_line();
	vbPos.pos1 = pos;
	vbPos.line2 = sn_line();
	vbPos.pos2 = pos+strlen(p);

	sn_advance_column(yyleng);
}

<VBSCRIPT>^{ospace}End{space}(Sub|Function){ospace} {
	sn_advance_column(yyleng);
	sn_insert_symbol(SN_FUNC_DEF, NULL, vbPos.name, sn_current_file(),
		   vbPos.line1, vbPos.pos1,
		   sn_line(), sn_column()
		   ,
		   SN_PUBLIC,
		   NULL, /*ret*/
		   NULL, /*arg types*/
		   NULL,
		   NULL,
		   vbPos.line1, vbPos.pos1,
		   vbPos.line2, vbPos.pos2
		   );
}

<VBSCRIPT>\%\> |
<VBSCRIPT>\<\/script\> {
    sn_advance_column(yyleng);
    BEGIN(INITIAL);
}

\<script{space}language=[^<]*(jscript|javascript)[^<]*\> |
\<script\> |
\<script{space}[^<]*\>  {
    sn_advance_column(yyleng);
    BEGIN(JSCRIPT);
}

<JSCRIPT>^{ospace}function{space}{identifier} {
	char *p;
	int pos;
	
	brackets = 0;
	haveFunc = 1;
	
	
	p = yytext + yyleng;
	while(noSPACE(*(p-1))) p--;
	pos = sn_column() + (p - yytext);
	
	//Store position
	strcpy(vbPos.name, p);
	vbPos.line1 = sn_line();
	vbPos.pos1 = pos;
	vbPos.line2 = sn_line();
	vbPos.pos2 = pos+strlen(p);

	sn_advance_column(yyleng);
}

<JSCRIPT>\{ {
    brackets ++;
    sn_advance_column(yyleng);
}

<JSCRIPT>\} {
    brackets --;
    sn_advance_column(yyleng);
    
    if (brackets == 0 && haveFunc) {
	sn_insert_symbol(SN_FUNC_DEF, NULL, vbPos.name, sn_current_file(),
		   vbPos.line1, vbPos.pos1,
		   sn_line(), sn_column()
		   ,
		   SN_PUBLIC,
		   NULL, /*ret*/
		   NULL, /*arg types*/
		   NULL,
		   NULL,
		   vbPos.line1, vbPos.pos1,
		   vbPos.line2, vbPos.pos2
		   );
    }
    if (brackets == 0) {
	haveFunc = 0;
    }
}

<JSCRIPT>\/\/.*$ {
    sn_advance_column(yyleng);
}

<JSCRIPT>\/\*$ {
    sn_advance_column(yyleng);
    drop_until("*/");
}

<JSCRIPT>\%\> {
    sn_advance_column(yyleng);
    if (current_language == LNG_JSCRIPT)
    {
	BEGIN(INITIAL);
    }
}

<JSCRIPT>\<\/script\> {
    sn_advance_column(yyleng);
    BEGIN(INITIAL);
}

\<\?IMPORT ||
\<\?xml {
    //Ignore import/xml command
    sn_advance_column(yyleng);
}

\<\? |
\<\?php {
    sn_advance_column(yyleng);
    BEGIN(PHP);
}

<PHP>^{ospace}function{space}{identifier} {
	char *p;
	int pos;
	
	haveFunc = 1;
	
	
	p = yytext + yyleng;
	while(noSPACE(*(p-1))) p--;
	pos = sn_column() + (p - yytext);
	
	//Store position
	strcpy(vbPos.name, p);
	vbPos.bracket = brackets;
	vbPos.line1 = sn_line();
	vbPos.pos1 = pos;
	vbPos.line2 = sn_line();
	vbPos.pos2 = pos+strlen(p);

	sn_advance_column(yyleng);
}

<PHP>^{ospace}class{space}{identifier} {
	char *p;
	int pos;
	
	haveClass = 1;
	
	
	p = yytext + yyleng;
	while(noSPACE(*(p-1))) p--;
	pos = sn_column() + (p - yytext);
	
	//Store position
	strcpy(clsPos.name, p);
	clsPos.bracket = brackets;
	clsPos.line1 = sn_line();
	clsPos.pos1 = pos;
	clsPos.line2 = sn_line();
	clsPos.pos2 = pos+strlen(p);

	sn_advance_column(yyleng);
}

<PHP>\/\/.*$ |
<PHP>#.* {
    sn_advance_column(yyleng);
}

<PHP>\/\*$ {
    sn_advance_column(yyleng);
    drop_until("*/");
}

<PHP>\{ {
    brackets ++;
    sn_advance_column(yyleng);
}

<PHP>\} {
    brackets --;
    sn_advance_column(yyleng);
    
    if (haveFunc && !haveClass && brackets == vbPos.bracket) {
	sn_insert_symbol(SN_FUNC_DEF, NULL, vbPos.name, sn_current_file(),
		   vbPos.line1, vbPos.pos1,
		   sn_line(), sn_column()
		   ,
		   SN_PUBLIC,
		   NULL, /*ret*/
		   NULL, /*arg types*/
		   NULL,
		   NULL,
		   vbPos.line1, vbPos.pos1,
		   vbPos.line2, vbPos.pos2
		   );
    }
    else if (haveFunc && brackets == vbPos.bracket) {
	sn_insert_symbol(SN_MBR_FUNC_DEF, clsPos.name, vbPos.name, sn_current_file(),
		   vbPos.line1, vbPos.pos1,
		   sn_line(), sn_column()
		   ,
		   SN_PUBLIC,
		   NULL, /*ret*/
		   NULL, /*arg types*/
		   NULL,
		   NULL,
		   vbPos.line1, vbPos.pos1,
		   vbPos.line2, vbPos.pos2
		   );
    }
    else if (haveClass && brackets == clsPos.bracket) {
	sn_insert_symbol(SN_CLASS_DEF, NULL, clsPos.name, sn_current_file(),
		   clsPos.line1, clsPos.pos1,
		   sn_line(), sn_column()
		   ,
		   0,
		   NULL, /*ret*/
		   NULL, /*arg types*/
		   NULL,
		   NULL,
		   clsPos.line1, clsPos.pos1,
		   clsPos.line2, clsPos.pos2
		   );
    }
    if (brackets == 0) {
	haveFunc = 0;
	haveClass = 0;
    }
}

<PHP>^{ospace}var{space}\${identifier} {
    if (haveClass) {
	char *p;
	int pos;
	
	p = yytext + yyleng;
	while(noSPACE(*(p-1))) p--;
	p++;	//ignore $
	pos = sn_column() + (p - yytext);
	
	sn_insert_symbol(SN_MBR_VAR_DEF, clsPos.name, p, sn_current_file(),
		   sn_line(), pos,
		   sn_line(), pos+strlen(p)
		   ,
		   SN_PUBLIC,
		   NULL, /*ret*/
		   NULL, /*arg types*/
		   NULL,
		   NULL,
		   sn_line(), pos,
		   sn_line(), pos+strlen(p)
		   );
    }
    sn_advance_column(yyleng);
}

<PHP>\?\> {
    sn_advance_column(yyleng);
    BEGIN(INITIAL);
}

\<style{space}[^<]*\> |
\<style\> |
\<style{space}*\>  {
    sn_advance_column(yyleng);
    BEGIN(STYLE);
}

<STYLE>\<\/style\> {
    sn_advance_column(yyleng);
    BEGIN(INITIAL);
}

<STYLE>{style-name} {
    //Ignore bookmakrs
    if (stylebracket == 0 && yytext[0] !='#') {
	char *p = strchr(yytext, '.'), *q;
	int pos;
	
	if (p == NULL)
	    p = yytext;
	else
	    p ++;
	    
	//:hover, :visited, :link (See http://www.w3.org/Style/LieBos2e/enter/)
	q = strchr(p, ':');
//	if (q != NULL) *q = 0;
	
	pos = sn_column() + (p - yytext);
	//Store position
	strcpy(stylePos[iStyle].name, p);
	stylePos[iStyle].line1 = sn_line();
	stylePos[iStyle].pos1 = pos;
	stylePos[iStyle].line2 = sn_line();
	stylePos[iStyle].pos2 = pos + strlen(p);
	
	if (iStyle < 16)
	    iStyle ++;
    }
    sn_advance_column(yyleng);
}

<STYLE>\{ {
    stylebracket ++;
    sn_advance_column(yyleng);
}

<STYLE>\} {
    stylebracket --;
    if (stylebracket == 0 && iStyle > 0) {
	int i;
	for(i=0; i<iStyle; i++) {
	    sn_insert_symbol(SN_CLASS_DEF, NULL, stylePos[i].name, sn_current_file(),
		   stylePos[i].line1, stylePos[i].pos1,
		   sn_line(), sn_column()
		   ,
		   SN_PUBLIC,
		   NULL, /*ret*/
		   NULL, /*arg types*/
		   NULL,
		   NULL,
		   stylePos[i].line1, stylePos[i].pos1,
		   stylePos[i].line2, stylePos[i].pos2
		   );
       }
       iStyle = 0;
    }
    sn_advance_column(yyleng);
}

<STYLE>\/\* {
	//skip comments
	sn_advance_column(yyleng);
	drop_until("*/");
}

<STYLE>\" {
	//skip strings
	sn_advance_column(yyleng);
	drop_until("\"");
}

\<[A-Za-z_][A-Za-z0-9_]* {
	strncpy(last_label.cls, yytext+1, yyleng-1);
	last_label.cls[yyleng-1] = 0;
	sn_advance_column(yyleng);
}

name=\"[A-Za-z0-9_.-]+\" |
name=[A-Za-z0-9_.]+ {
	char *q;
	int len, plen;
	
	p = yytext + 5;
	sn_advance_column(5);
	plen = len = yyleng - 5;
	if (*p == '"') {
		p++, plen -= 2;
		sn_advance_column(1);
		for(q=p; *q; q++) {
			if (*q == '"') {
				*q = 0;
				break;
			}
		}
	}
	sn_insert_symbol(SN_MBR_FUNC_DEF, last_label.cls, p, sn_current_file(), sn_line(),
                   sn_column(), sn_line(), sn_column() + plen,
                   0, NULL, NULL, NULL, NULL, sn_line(), sn_column(),
                   sn_line(), sn_column() + plen);

	sn_advance_column(yyleng - 5);
}

\[\%[A-Za-z0-9_]+\%\] {
	char *q;
	int plen;
	
	p = yytext + 2;
	plen = yyleng - 4;
	sn_advance_column(2);
	for(q=p; *q; q++) {
		if (*q == '%') {
			*q = 0;
			break;
		}
	}

	sn_insert_symbol(SN_GLOB_VAR_DEF, NULL, p, sn_current_file(), sn_line(),
                   sn_column(), sn_line(), sn_column() + plen,
                   0, NULL, NULL, NULL, NULL, sn_line(), sn_column(),
                   sn_line(), sn_column() + plen);

	sn_advance_column(yyleng - 2);
}

. |
<VBSCRIPT>. |
<JSCRIPT>. |
<PHP>. |
<STYLE>. {
	sn_advance_column(yyleng); /* eat text */
}

\n |
<VBSCRIPT>\n |
<JSCRIPT>\n |
<PHP>\n |
<STYLE>\n {
	sn_advance_line(); sn_reset_column();
}

%%
  
void
reset()
{
  sn_reset_line();
  sn_reset_column();
}

int
main(int argc, char *argv[])
{
    memset(&vbPos, 0, sizeof(vbPos));
    memset(&clsPos, 0, sizeof(clsPos));
    memset(&stylePos, 0, sizeof(stylePos));
    iStyle = 0;
    stylebracket = 0;
    
    return sn_main(argc, argv, group, &yyin, yylex, reset);
}

static int drop_until(char* term)
{
	int c, i;
	int wi = 0, wl;
	char wrd[32];
	wrd[0] = 0;
	wl = strlen(term);

	for (; (c = (int)input()); )
	{
		sn_advance_column(1);
		if (wi < wl)
		{
		    wrd[wi++] = c;
		}
		else
		{
		    for(i=0; i<wi; i++)
			wrd[i] = wrd[i+1];
		    wrd[wi-1] = c;
		}
		wrd[wi] = 0;
		
		switch (c)
		{
		case '\n':
			sn_advance_line();
			sn_reset_column();
			break;

		case EOF:
			return 0;
			break;
		}
		
		if (strncmp(wrd, term, wl) == 0)
		{
		    break;
		}
	}
	return 0;
}

